/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.python.antlr.BaseParser;
import org.python.antlr.NoCloseReaderStream;
import org.python.antlr.ParseException;
import org.python.antlr.PythonPartialLexer;
import org.python.antlr.PythonPartialParser;
import org.python.antlr.PythonTokenSource;
import org.python.antlr.PythonTree;
import org.python.antlr.base.mod;
import org.python.antlr.runtime.CommonTokenStream;
import org.python.core.CompileMode;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyIndentationError;
import org.python.core.PySyntaxError;
import org.python.core.PyUnicode;
import org.python.core.io.BufferedIOBase;
import org.python.core.io.BufferedReader;
import org.python.core.io.RawIOBase;
import org.python.core.io.StreamIO;
import org.python.core.io.TextIOInputStream;
import org.python.core.io.UniversalIOWrapper;
import org.python.core.util.StringUtil;

public class ParserFacade {
    private static int MARK_LIMIT = 100000;
    private static final Pattern pep263EncodingPattern = Pattern.compile("#.*coding[:=]\\s*([-\\w.]+)");

    private ParserFacade() {
    }

    private static String getLine(ExpectedEncodingBufferedReader expectedEncodingBufferedReader, int n) {
        if (expectedEncodingBufferedReader == null) {
            return "";
        }
        String string = null;
        try {
            for (int i = 0; i < n; ++i) {
                string = expectedEncodingBufferedReader.readLine();
            }
            if (string == null) {
                return string;
            }
            if (expectedEncodingBufferedReader.encoding != null) {
                string = new PyUnicode(string).encode(expectedEncodingBufferedReader.encoding);
            }
            return string + "\n";
        }
        catch (IOException iOException) {
            return string;
        }
    }

    public static PyException fixParseError(ExpectedEncodingBufferedReader expectedEncodingBufferedReader, Throwable throwable, String string) {
        if (expectedEncodingBufferedReader != null) {
            try {
                expectedEncodingBufferedReader.reset();
            }
            catch (IOException iOException) {
                expectedEncodingBufferedReader = null;
            }
        }
        if (throwable instanceof ParseException) {
            ParseException parseException = (ParseException)throwable;
            PythonTree pythonTree = (PythonTree)parseException.node;
            int n = parseException.line;
            int n2 = parseException.charPositionInLine;
            if (pythonTree != null) {
                n = pythonTree.getLine();
                n2 = pythonTree.getCharPositionInLine();
            }
            String string2 = ParserFacade.getLine(expectedEncodingBufferedReader, n);
            String string3 = parseException.getMessage();
            if (parseException.getType() == Py.IndentationError) {
                return new PyIndentationError(string3, n, n2, string2, string);
            }
            return new PySyntaxError(string3, n, n2, string2, string);
        }
        if (throwable instanceof CharacterCodingException) {
            String string4 = expectedEncodingBufferedReader.encoding == null ? "Non-ASCII character in file '" + string + "', but no encoding declared" + "; see http://www.python.org/peps/pep-0263.html for details" : "Illegal character in file '" + string + "' for encoding '" + expectedEncodingBufferedReader.encoding + "'";
            throw Py.SyntaxError(string4);
        }
        return Py.JavaError(throwable);
    }

    /*
     * Loose catch block
     */
    public static mod parseExpressionOrModule(Reader reader, String string, CompilerFlags compilerFlags) {
        mod mod2;
        ExpectedEncodingBufferedReader expectedEncodingBufferedReader = null;
        try {
            expectedEncodingBufferedReader = ParserFacade.prepBufReader(reader, compilerFlags, string);
            mod2 = ParserFacade.parse(expectedEncodingBufferedReader, CompileMode.eval, string, compilerFlags);
        }
        catch (Throwable throwable) {
            if (expectedEncodingBufferedReader == null) {
                throw Py.JavaError(throwable);
            }
            expectedEncodingBufferedReader.reset();
            mod mod3 = ParserFacade.parse(expectedEncodingBufferedReader, CompileMode.exec, string, compilerFlags);
            ParserFacade.close(expectedEncodingBufferedReader);
            return mod3;
            {
                catch (Throwable throwable2) {
                    try {
                        throw ParserFacade.fixParseError(expectedEncodingBufferedReader, throwable2, string);
                    }
                    catch (Throwable throwable3) {
                        ParserFacade.close(expectedEncodingBufferedReader);
                        throw throwable3;
                    }
                }
            }
        }
        ParserFacade.close(expectedEncodingBufferedReader);
        return mod2;
    }

    private static mod parse(ExpectedEncodingBufferedReader expectedEncodingBufferedReader, CompileMode compileMode, String string, CompilerFlags compilerFlags) throws Throwable {
        expectedEncodingBufferedReader.mark(MARK_LIMIT);
        if (compileMode != null) {
            NoCloseReaderStream noCloseReaderStream = new NoCloseReaderStream(expectedEncodingBufferedReader);
            BaseParser baseParser = new BaseParser(noCloseReaderStream, string, compilerFlags.encoding);
            return compileMode.dispatch(baseParser);
        }
        throw Py.ValueError("parse kind must be eval, exec, or single");
    }

    public static mod parse(Reader reader, CompileMode compileMode, String string, CompilerFlags compilerFlags) {
        mod mod2;
        ExpectedEncodingBufferedReader expectedEncodingBufferedReader = null;
        try {
            expectedEncodingBufferedReader = ParserFacade.prepBufReader(reader, compilerFlags, string);
            mod2 = ParserFacade.parse(expectedEncodingBufferedReader, compileMode, string, compilerFlags);
        }
        catch (Throwable throwable) {
            try {
                throw ParserFacade.fixParseError(expectedEncodingBufferedReader, throwable, string);
            }
            catch (Throwable throwable2) {
                ParserFacade.close(expectedEncodingBufferedReader);
                throw throwable2;
            }
        }
        ParserFacade.close(expectedEncodingBufferedReader);
        return mod2;
    }

    public static mod parse(InputStream inputStream, CompileMode compileMode, String string, CompilerFlags compilerFlags) {
        mod mod2;
        ExpectedEncodingBufferedReader expectedEncodingBufferedReader = null;
        try {
            expectedEncodingBufferedReader = ParserFacade.prepBufReader(inputStream, compilerFlags, string, false);
            mod2 = ParserFacade.parse(expectedEncodingBufferedReader, compileMode, string, compilerFlags);
        }
        catch (Throwable throwable) {
            try {
                throw ParserFacade.fixParseError(expectedEncodingBufferedReader, throwable, string);
            }
            catch (Throwable throwable2) {
                ParserFacade.close(expectedEncodingBufferedReader);
                throw throwable2;
            }
        }
        ParserFacade.close(expectedEncodingBufferedReader);
        return mod2;
    }

    public static mod parse(String string, CompileMode compileMode, String string2, CompilerFlags compilerFlags) {
        mod mod2;
        ExpectedEncodingBufferedReader expectedEncodingBufferedReader = null;
        try {
            expectedEncodingBufferedReader = ParserFacade.prepBufReader(string, compilerFlags, string2);
            mod2 = ParserFacade.parse(expectedEncodingBufferedReader, compileMode, string2, compilerFlags);
        }
        catch (Throwable throwable) {
            try {
                throw ParserFacade.fixParseError(expectedEncodingBufferedReader, throwable, string2);
            }
            catch (Throwable throwable2) {
                ParserFacade.close(expectedEncodingBufferedReader);
                throw throwable2;
            }
        }
        ParserFacade.close(expectedEncodingBufferedReader);
        return mod2;
    }

    public static mod partialParse(String string, CompileMode compileMode, String string2, CompilerFlags compilerFlags, boolean bl) {
        mod mod2;
        ExpectedEncodingBufferedReader expectedEncodingBufferedReader = null;
        try {
            expectedEncodingBufferedReader = ParserFacade.prepBufReader(string, compilerFlags, string2);
            mod2 = ParserFacade.parse(expectedEncodingBufferedReader, compileMode, string2, compilerFlags);
        }
        catch (Throwable throwable) {
            PyException pyException;
            block5: {
                mod mod3;
                try {
                    pyException = ParserFacade.fixParseError(expectedEncodingBufferedReader, throwable, string2);
                    if (expectedEncodingBufferedReader == null || !ParserFacade.validPartialSentence(expectedEncodingBufferedReader, compileMode, string2)) break block5;
                    mod3 = null;
                }
                catch (Throwable throwable2) {
                    ParserFacade.close(expectedEncodingBufferedReader);
                    throw throwable2;
                }
                ParserFacade.close(expectedEncodingBufferedReader);
                return mod3;
            }
            throw pyException;
        }
        ParserFacade.close(expectedEncodingBufferedReader);
        return mod2;
    }

    private static boolean validPartialSentence(java.io.BufferedReader bufferedReader, CompileMode compileMode, String string) {
        PythonPartialLexer pythonPartialLexer = null;
        try {
            bufferedReader.reset();
            NoCloseReaderStream noCloseReaderStream = new NoCloseReaderStream(bufferedReader);
            pythonPartialLexer = new PythonPartialLexer(noCloseReaderStream);
            CommonTokenStream commonTokenStream = new CommonTokenStream(pythonPartialLexer);
            PythonTokenSource pythonTokenSource = new PythonTokenSource(commonTokenStream, string);
            commonTokenStream = new CommonTokenStream(pythonTokenSource);
            PythonPartialParser pythonPartialParser = new PythonPartialParser(commonTokenStream);
            switch (compileMode) {
                case single: {
                    pythonPartialParser.single_input();
                    break;
                }
                case eval: {
                    pythonPartialParser.eval_input();
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        catch (Exception exception) {
            return pythonPartialLexer.eofWhileNested;
        }
        return true;
    }

    private static ExpectedEncodingBufferedReader prepBufReader(Reader reader, CompilerFlags compilerFlags, String string) throws IOException {
        compilerFlags.source_is_utf8 = true;
        compilerFlags.encoding = "utf-8";
        java.io.BufferedReader bufferedReader = new java.io.BufferedReader(reader);
        bufferedReader.mark(MARK_LIMIT);
        if (ParserFacade.findEncoding(bufferedReader) != null) {
            throw new ParseException("encoding declaration in Unicode string");
        }
        bufferedReader.reset();
        return new ExpectedEncodingBufferedReader((Reader)bufferedReader, null);
    }

    private static ExpectedEncodingBufferedReader prepBufReader(InputStream inputStream, CompilerFlags compilerFlags, String string, boolean bl) throws IOException {
        return ParserFacade.prepBufReader(inputStream, compilerFlags, string, bl, true);
    }

    private static ExpectedEncodingBufferedReader prepBufReader(InputStream inputStream, CompilerFlags compilerFlags, String string, boolean bl, boolean bl2) throws IOException {
        Object object;
        Object object2;
        inputStream = new BufferedInputStream(inputStream);
        boolean bl3 = ParserFacade.adjustForBOM(inputStream);
        String string2 = ParserFacade.readEncoding(inputStream);
        if (string2 == null) {
            if (bl3) {
                string2 = "utf-8";
            } else if (compilerFlags != null && compilerFlags.encoding != null) {
                string2 = compilerFlags.encoding;
            }
        }
        if (compilerFlags.source_is_utf8) {
            if (string2 != null) {
                throw new ParseException("encoding declaration in Unicode string");
            }
            string2 = "utf-8";
        }
        compilerFlags.encoding = string2;
        if (bl2) {
            object2 = new StreamIO(inputStream, true);
            object = new BufferedReader((RawIOBase)object2, 0);
            UniversalIOWrapper universalIOWrapper = new UniversalIOWrapper((BufferedIOBase)object);
            inputStream = new TextIOInputStream(universalIOWrapper);
        }
        try {
            object2 = string2 == null ? (bl ? Charset.forName("ISO-8859-1") : Charset.forName("ascii")) : Charset.forName(string2);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw new PySyntaxError("Unknown encoding: " + string2, 1, 0, "", string);
        }
        object = ((Charset)object2).newDecoder();
        ((CharsetDecoder)object).onMalformedInput(CodingErrorAction.REPORT);
        ((CharsetDecoder)object).onUnmappableCharacter(CodingErrorAction.REPORT);
        return new ExpectedEncodingBufferedReader((Reader)new InputStreamReader(inputStream, (CharsetDecoder)object), string2);
    }

    private static ExpectedEncodingBufferedReader prepBufReader(String string, CompilerFlags compilerFlags, String string2) throws IOException {
        if (compilerFlags.source_is_utf8) {
            return ParserFacade.prepBufReader(new StringReader(string), compilerFlags, string2);
        }
        byte[] byArray = StringUtil.toBytes(string);
        return ParserFacade.prepBufReader(new ByteArrayInputStream(byArray), compilerFlags, string2, true, false);
    }

    private static boolean adjustForBOM(InputStream inputStream) throws IOException {
        inputStream.mark(3);
        int n = inputStream.read();
        if (n == 239) {
            if (inputStream.read() != 187) {
                throw new ParseException("Incomplete BOM at beginning of file");
            }
            if (inputStream.read() != 191) {
                throw new ParseException("Incomplete BOM at beginning of file");
            }
            return true;
        }
        inputStream.reset();
        return false;
    }

    private static String readEncoding(InputStream inputStream) throws IOException {
        inputStream.mark(MARK_LIMIT);
        String string = null;
        java.io.BufferedReader bufferedReader = new java.io.BufferedReader(new InputStreamReader(inputStream, "ISO-8859-1"), 512);
        string = ParserFacade.findEncoding(bufferedReader);
        inputStream.reset();
        return ParserFacade.encodingMap(string);
    }

    private static String findEncoding(java.io.BufferedReader bufferedReader) throws IOException {
        String string;
        String string2 = null;
        for (int i = 0; i < 2 && (string = bufferedReader.readLine()) != null; ++i) {
            String string3 = ParserFacade.matchEncoding(string);
            if (string3 == null) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    private static String encodingMap(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("Latin-1") || string.equals("latin-1")) {
            return "ISO8859_1";
        }
        return string;
    }

    private static String matchEncoding(String string) {
        Matcher matcher = pep263EncodingPattern.matcher(string);
        boolean bl = matcher.find();
        if (bl && matcher.groupCount() == 1) {
            String string2 = matcher.group(1);
            return string2;
        }
        return null;
    }

    private static void close(java.io.BufferedReader bufferedReader) {
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class ExpectedEncodingBufferedReader
    extends java.io.BufferedReader {
        public final String encoding;

        public ExpectedEncodingBufferedReader(Reader reader, String string) {
            super(reader);
            this.encoding = string;
        }
    }
}

